
# Installing Dependencies

```bash
conda env create
conda activate bayes-downstream-env
```

# NAPSU-MQ Source
Most of the code in `lib/` is from the 
[NAPSU-MQ implementation](https://github.com/DPBayes/NAPSU-MQ-experiments)
of [Räisä et al.](https://proceedings.mlr.press/v206/raisa23a.html) under 
the Apache 2.0 license. We've added the files 
`lib/max_ent_inference_unmarginalised.py` and `lib/bayesian_logistic_regression.py`.

# DP-GLM
The DP-GLM baseline uses code from 
[Kulkarni et al.](http://proceedings.mlr.press/v139/kulkarni21a.html) The 
code is not public, so we could not include it in the submission.

# Running the Code

The Gaussian example is in the notebook `bayesian-inference-gaussian-test.ipynb`.

For the toy data experiment, we use 
[Snakemake](https://snakemake.readthedocs.io/en/stable/). The experiment can 
be run with 
```bash
snakemake -j 6
```
which runs 6 jobs in parallel. After the command finishes, the plotting 
notebook `workflow/scripts/toy-data/report.py.ipynb` can be run to 
plot the results.

Figures are saved in the `figures/` directory, and separated into subdirectories 
of both examples.